<?php

namespace App\Controller;

use App\Entity\SqrGeneratedKeyDomaine;
use App\Form\SqrGeneratedKeyDomaineType;
use App\Repository\SqrGeneratedKeyDomaineRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @Route("/sqr/generated/key/domaine")
 */
class SqrGeneratedKeyDomaineController extends AbstractController
{
    /**
     * @Route("/", name="app_sqr_generated_key_domaine_index", methods={"GET"})
     */
    public function index(SqrGeneratedKeyDomaineRepository $sqrGeneratedKeyDomaineRepository): Response
    {
        return $this->render('sqr_generated_key_domaine/index.html.twig', [
            'sqr_generated_key_domaines' => $sqrGeneratedKeyDomaineRepository->findAll(),
        ]);
    }

    /**
     * @Route("/new", name="app_sqr_generated_key_domaine_new", methods={"GET", "POST"})
     */
    public function new(Request $request, SqrGeneratedKeyDomaineRepository $sqrGeneratedKeyDomaineRepository): Response
    {
        $sqrGeneratedKeyDomaine = new SqrGeneratedKeyDomaine();
        $form = $this->createForm(SqrGeneratedKeyDomaineType::class, $sqrGeneratedKeyDomaine);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $sqrGeneratedKeyDomaineRepository->add($sqrGeneratedKeyDomaine, true);

            return $this->redirectToRoute('app_sqr_generated_key_domaine_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->renderForm('sqr_generated_key_domaine/new.html.twig', [
            'sqr_generated_key_domaine' => $sqrGeneratedKeyDomaine,
            'form' => $form,
        ]);
    }

    /**
     * @Route("/{id}", name="app_sqr_generated_key_domaine_show", methods={"GET"})
     */
    public function show(SqrGeneratedKeyDomaine $sqrGeneratedKeyDomaine): Response
    {
        return $this->render('sqr_generated_key_domaine/show.html.twig', [
            'sqr_generated_key_domaine' => $sqrGeneratedKeyDomaine,
        ]);
    }

    /**
     * @Route("/{id}/edit", name="app_sqr_generated_key_domaine_edit", methods={"GET", "POST"})
     */
    public function edit(Request $request, SqrGeneratedKeyDomaine $sqrGeneratedKeyDomaine, SqrGeneratedKeyDomaineRepository $sqrGeneratedKeyDomaineRepository): Response
    {
        $form = $this->createForm(SqrGeneratedKeyDomaineType::class, $sqrGeneratedKeyDomaine);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $sqrGeneratedKeyDomaineRepository->add($sqrGeneratedKeyDomaine, true);

            return $this->redirectToRoute('app_sqr_generated_key_domaine_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->renderForm('sqr_generated_key_domaine/edit.html.twig', [
            'sqr_generated_key_domaine' => $sqrGeneratedKeyDomaine,
            'form' => $form,
        ]);
    }

    /**
     * @Route("/{id}", name="app_sqr_generated_key_domaine_delete", methods={"POST"})
     */
    public function delete(Request $request, SqrGeneratedKeyDomaine $sqrGeneratedKeyDomaine, SqrGeneratedKeyDomaineRepository $sqrGeneratedKeyDomaineRepository): Response
    {
        if ($this->isCsrfTokenValid('delete'.$sqrGeneratedKeyDomaine->getId(), $request->request->get('_token'))) {
            $sqrGeneratedKeyDomaineRepository->remove($sqrGeneratedKeyDomaine, true);
        }

        return $this->redirectToRoute('app_sqr_generated_key_domaine_index', [], Response::HTTP_SEE_OTHER);
    }
}
